%-------------------------------------------------------------------------%
% Filename: figs_App_D_5_6_7_plot.m  
% Part of the paper "CS4ML: A general framework for active learning with
% arbitrary data based on Christoffel functions"
% 
% Description: generates the plots for Figure 13 in Appendix D, surrogate 
% Christoffel function for collocation, initial, and boundary data.
%-------------------------------------------------------------------------%
clear all; close all; clc;
addpath(genpath('../../utils'));

% Loop over subfigures % 
for fig_num = 5
    for row_num = 1:4
        for col_num = 1:3
    
            fig_name = ['fig_AppD','_', num2str(fig_num),'_',num2str(row_num),'_',num2str(col_num)];
            load(['../../data/Figure App D 5 6 7/',['fig_AppD','_', num2str(fig_num),'_',num2str(row_num)]]);
            
            % load plot data 
            data_name = '../../colab_data/plot_data_example_1_dim_2.mat';
            load(data_name);

            % parameters
            trial   = 1;        % trial number 1
            nb_samp = 1;        % sampling CAS:1 | MSC: 2

            fig = figure();
            
            if col_num == 1 
                x_values_data = reshape(x_values_data(:,trial,1), 100, 100);
                s = surf(T(2:end-1,2:end),X(2:end-1,2:end),x_values_data); 
                s.EdgeColor = 'none';
                grid off 
                view(2)

            elseif col_num == 2
                plot(x_plot_init_data, y_values_data(:,trial,nb_samp))
                grid on 
                xlabel('$x$','Interpreter','latex') 

            elseif col_num == 3
                plot(t_plot_bound_data(1:end/2), z_values_data(1:end/2,trial,nb_samp))
                hold on
                plot(t_plot_bound_data(end/2+1:end), z_values_data(end/2+1:end,trial,nb_samp))
                grid on 
                xlabel('$t$','Interpreter','latex') 
            else
                disp(['incorrect col number, try 1, 2, or 3']);
            end
 
            saveas(fig,['../../figs/Figure App D 5 6 7/',fig_name],'epsc');
        end
    end
end